SELECT document_type, path FROM sys.fulltext_document_types


exec sp_fulltext_service 'load_os_resources', 1;
exec sp_fulltext_service 'verify_signature', 0;
go


-- uyj bazy danych test
USE [test]
GO

-- utwrz tabel myPDF
CREATE TABLE [dbo].[myPDF](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[FileName] [varchar](100) COLLATE Polish_CI_AS NULL,
	[FileExt] [nvarchar](10) COLLATE Polish_CI_AS NULL,
	[FileSrc] [varbinary](max) NULL,
 CONSTRAINT [PK_myPDF] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO


ISNERT INTO [test].[dbo].[myPDF] ([FileName], [FileExt]) 
VALUES ('example.pdf', '.pdf')

UDPATE [test].[dbo].[myPDF] 
SET [FileSrc] = (SELECT * FROM OPENROWSET(BULK 'c:\example.pdf', SINGLE_BLOB)AS x ) 
WHERE [FileName]='example.pdf'


SELECT * FROM myPDF



-- uyj bazy danych test
USE [test]
GO

-- utwrz katalo pdf_catalog
CREATE FULLTEXT CATALOG [pdf_catalog]
IN PATH N'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\FTData'
WITH ACCENT_SENSITIVITY = ON
AUTHORIZATION [dbo]


CREATE FULLTEXT INDEX ON myPDF
(FileSrc TYPE COLUMN FileExt)
KEY INDEX PK_myPDF
ON pdf_catalog
WITH CHANGE_TRACKING AUTO


SELECT [FileName] FROM myPDF WHERE CONTAINS(*, 'codec')